<?
// Copyright 2002 Timothy Scott Morizot
//
// This file is part of Morizot's IPTABLES Firewall Generator.
//
// Morizot's IPTABLES Firewall Generator is free software;
// you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Morizot's IPTABLES Firewall Generator is distributed
// in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// in this distribution; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//Set type to plain text
header("Content-Type: text/plain");

?>
#!/bin/sh
#
# Generated iptables firewall script for the Linux 2.4 kernel
# 
# This generator is primarily designed for RedHat installations,
# although it should be adaptable for others.
#
# It can be executed with the typical start and stop arguments.
# If used with stop, it will stop after flushing the firewall.

# Redhat installation instructions
#
# 1. Ensure that ipchains will not automatically start.
#    chkconfig --level 0123456 ipchains off
#    This will make sure that the ipchains init.d script
#    is not linked to an S file in any of the rc directories.
#
# 2. Stop ipchains if it's running.
#    service ipchains stop
#
# 3. Execute lsmod to see if the ipchains kernel module is still loaded.
#    If it is, use rmmod to unload it.
#
# 4. Have the system link the iptables init.d startup script into run states
#    2, 3, and 5.
#    chkconfig --level 235 iptables on
#
# 5. Save this script and execute it to load the ruleset from this file.
#    You may need to run the dos2unix command on it to remove carraige returns.
#
# 6. Save the ruleset to /etc/sysconfig/iptables.  This can be done two ways.
#    service iptables save
#    iptables-save > /etc/sysconfig/iptables
#
# 7. The ruleset will be restored by the /etc/init.d/iptables script on boot.
#
# NOTE: The /etc/init.d/iptables script can be modified to run this script
# instead.  If you do so, save a copy so you can reapply your modifications
# after upgrading the iptables package.  The advantage of using this script for
# the ongoing operation of the firewall is it gives you greater control over
# the modules and rulesets used.  The above is simpler, however.

###############################################################################
# 
# Local Settings
#

# IPTables Location - adjust if needed

IPT="/sbin/iptables"

# Internet Interface
<?
print("INET_IFACE=\"$INET_IFACE\"\n");

if ($GATEWAY == "true")
{
	print("\n# Local Interface Information\n");
	print("LOCAL_IFACE=\"$LOCAL_IFACE\"\n");
	print("LOCAL_IP=\"$LOCAL_IP\"\n");
	print("LOCAL_NET=\"$LOCAL_NET\"\n");
	print("LOCAL_BCAST=\"$LOCAL_BCAST\"\n");
}
else
{
	print("INET_ADDRESS=\"$INET_ADDRESS\"\n");
}	
?>

# Localhost Interface

LO_IFACE="lo"
LO_IP="127.0.0.1"

###############################################################################
#
# Load Modules
#

echo "Loading kernel modules ..."

# Run depmod

/sbin/depmod -a

# Required Modules

/sbin/modprobe ip_conntrack
/sbin/modprobe ip_tables
/sbin/modprobe iptable_filter
/sbin/modprobe iptable_mangle
/sbin/modprobe iptable_nat
/sbin/modprobe ipt_LOG
/sbin/modprobe ipt_limit
/sbin/modprobe ipt_MASQUERADE

# Optional Modules

#/sbin/modprobe ipt_owner
/sbin/modprobe ipt_REJECT
<?
if ($FTP_OUT == "true")
{
	print("#");
}
print("/sbin/modprobe ip_conntrack_ftp\n");

if ($IRC_OUT == "true")
{
	print("#");
}
print("/sbin/modprobe ip_conntrack_irc\n");
?>

###############################################################################
#
# /proc Configuration
#

# Required
echo "1" > /proc/sys/net/ipv4/ip_forward

# Optional
echo "1" > /proc/sys/net/ipv4/ip_dynaddr
echo "1" > /proc/sys/net/ipv4/conf/all/rp_filter
echo "1" > /proc/sys/net/ipv4/conf/all/proxy_arp

###############################################################################
#
# Flush Any Existing Rules or Chains
#

echo "Flushing Tables ..."

# Reset Default Policies
$IPT -P INPUT ACCEPT
$IPT -P FORWARD ACCEPT
$IPT -P OUTPUT ACCEPT
$IPT -t nat -P PREROUTING ACCEPT
$IPT -t nat -P POSTROUTING ACCEPT
$IPT -t nat -P OUTPUT ACCEPT
$IPT -t mangle -P PREROUTING ACCEPT
$IPT -t mangle -P OUTPUT ACCEPT

# Flush all rules
$IPT -F
$IPT -t nat -F
$IPT -t mangle -F

# Erase all non-default chains
$IPT -X
$IPT -t nat -X
$IPT -t mangle -X

if [ "$1" = "stop" ]
then
	echo "Firewall completely flushed!  Now running with no firewall."
	exit 0
fi

###############################################################################
#
# Rules Configuration
#

###############################################################################
#
# Filter Table
#
###############################################################################

# Set Policies

$IPT -P INPUT DROP
$IPT -P OUTPUT DROP
$IPT -P FORWARD DROP

###############################################################################
#
# User-Specified Chains
#
# Create user chains to reduce the number of rules each packet
# must traverse.

echo "Create and populate custom rule chains ..."

# Create a chain to filter bad tcp packets

$IPT -N bad_tcp_packets

# Create separate chains for icmp, tcp (incoming and outgoing), and incoming udp packets.

$IPT -N icmp_packets

# Used for UDP packets inbound from the Internet
$IPT -N udp_inbound

# Used to block outbound UDP services from internal network
# Default to allow all
$IPT -N udp_outbound

# Used to allow inbound services if desired
# Default fail except for established sessions
$IPT -N tcp_inbound

# Used to block outbound services from internal network
# Default to allow all
$IPT -N tcp_outbound

###############################################################################
#
# Populate User Chains
#

# bad_tcp_packets chain
#
# All tcp packets will traverse this chain first.
# Every new connection attempt should begin with
# a syn packet.  About the only thing that does
# not is a portscan.  This drops packets in state
# NEW that are not syn.  Also log and drop
# INVALID tcp packets.
 
$IPT -A bad_tcp_packets -p tcp ! --syn -m state --state NEW -j LOG \
    --log-prefix "New not syn:"
$IPT -A bad_tcp_packets -p tcp ! --syn -m state --state NEW -j DROP

$IPT -A bad_tcp_packets -p tcp -m state --state INVALID -j LOG \
    --log-prefix "Invalid packet:"
$IPT -A bad_tcp_packets -p tcp -m state --state INVALID -j DROP

# All good, so return
$IPT -A bad_tcp_packets -p tcp -j RETURN

# icmp_packets chain
#
# This chain is for inbound icmp packets only.
# Types 8 (Echo Request) is not accepted by default
# Enable it if you want remote hosts to be able to reach you.
# 11 (Time Exceeded) is the only one accepted
# that would not already be covered by the established
# connection rule.  Applied to INPUT on the external interface.
# 
# See: http://www.ee.siue.edu/~rwalden/networking/icmp.html
# for more info on ICMP

#$IPT -A icmp_packets -p ICMP -s 0/0 --icmp-type 8 -j ACCEPT
$IPT -A icmp_packets -p ICMP -s 0/0 --icmp-type 11 -j ACCEPT

#
# Identify ports at:
#    http://www.chebucto.ns.ca/~rakerman/port-table.html
#    http://www.iana.org/assignments/port-numbers

# udp_inbound chain
#
# This chain describes the inbound UDP packets it will accept.
# It's applied to INPUT on the external interface

<?
//NTP server on gateway
if ($NTP_IN == "true")
{
	print("# Network Time Protocol (NTP) Server\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 123 -j ACCEPT\n\n");
}

//DNS Server on gateway
if ($DNS_IN == "true")
{
	print("# DNS Server\n");
	print("# Configure the server to use port 53 as the source port for requests\n");
	print("# Note, if you run a caching-only name server, you can comment out this line.\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 53 -j ACCEPT\n\n");
	print("# If you don't query-source the server to port 53, uncomment this rule.\n");
	print("# \$IPT -A udp_inbound -p UDP -s 0/0 --source-port 53 -j ACCEPT\n\n");
}

//If dynamic, then allow DHCP requests
if ($DYNAMIC_IP == "true")
{
	print("# Allow inbound DHCP packets\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --source-port 67 --destination-port 68 -j ACCEPT\n\n");
}

?>

# You may decide to accept all unprivileged inbound UDP.
# If you do, this is the rule.  I do not recommend it, though.
# $IPT -A udp_inbound -p UDP -s 0/0 --destination-port 1024:65535 --source-port 1024:65535 -j ACCEPT

# udp_outbound chain
#
# This chain is used with a private network to prevent forwarding for
# UDP requests on specific protocols.  Applied to the FORWARD rule from
# the internal network.  Ends with an ACCEPT

<?

//If IM blocked, block ICQ, uses UDP 4000
if ($IM_OUT == "true")
{
	print("# ICQ uses UDP 4000 - Instant messaging blocked\n");
	print("\$IPT -A udp_outbound -p UDP -s 0/0 --destination-port 4000 -j REJECT\n\n");
}

?>

# No match, so ACCEPT
$IPT -A udp_outbound -p UDP -s 0/0 -j ACCEPT

# tcp_inbound chain
#
# This chain is used to allow inbound connections to the
# system/gateway.  Use with care.  It defaults to none.
# It's applied on INPUT from the external interface.

<?

//DNS Server - TCP (most are UDP, so this could be disabled)
if ($DNS_IN == "true")
{
	print("# DNS Server - Allow TCP connections (zone transfers and large requests)\n");
	print("# This is disabled by default.  DNS Zone transfers occur via TCP.\n");
	print("# If you need to allow transfers over the net you need to uncomment this line.\n");
	print("# If you allow queries from the 'net, you also need to be aware that although\n");
	print("# DNS queries use UDP by default, a truncated UDP query can legally be submitted\n");
	print("# via TCP instead.  You probably will never need it, but should be aware of the fact.\n");
	print("# \$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 53 -j ACCEPT\n\n");
}

//HTTP
if ($HTTP_IN == "true")
{
	print("# Web Server\n\n");
	print("# HTTP\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 80 -j ACCEPT\n\n");
	print("# HTTPS (Secure Web Server)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 443 -j ACCEPT\n\n");
}

//FTP
if ($FTP_IN == "true")
{
	print("# FTP Server (Control)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 21 -j ACCEPT\n\n");
	print("# FTP Server (Data)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 20 -j ACCEPT\n\n");
}

//Email
if ($EMAIL_IN == "true")
{
	print("# Email Server (SMTP)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 25 -j ACCEPT\n\n");
	print("# Email Server (POP3)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 110 -j ACCEPT\n\n");
	print("# Email Server (IMAP4)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 143 -j ACCEPT\n\n");
}

//SSH
if ($SSH_IN == "true")
{
	print("# sshd\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 22 -j ACCEPT\n\n");
}

?>

# tcp_outbound chain
#
# This chain is used with a private network to prevent forwarding for
# requests on specific protocols.  Applied to the FORWARD rule from
# the internal network.  Ends with an ACCEPT

<?
if ($IRC_OUT == "true")
{
	print("# Block IRC\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 194 -j REJECT\n\n");
}

if ($TELNET_OUT == "true")
{
	print("# Block Outbound Telnet\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 23 -j REJECT\n\n");
}

if ($SSH_OUT == "true")
{
	print("# Block SSH\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 22 -j REJECT\n\n");
}

if ($NEWS_OUT == "true")
{
	print("# Block Usenet Access\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 119 -j REJECT\n\n");
}

if ($HTTP_OUT == "true")
{
	print("# Block Web Access\n\n");
	print("# HTTP\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 80 -j REJECT\n\n");
	print("# HTTPS (Secure Web)\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 443 -j REJECT\n\n");
}

if ($FTP_OUT == "true")
{
	print("# Block FTP Access\n\n");
	print("# Control\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 21 -j REJECT\n\n");
	print("# Data\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 20 -j REJECT\n\n");
}

if ($IM_OUT == "true")
{
	print("# Block Instant Messaging\n\n");
	print("# AIM\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 5190 -j REJECT\n\n");
	print("# AIM Images\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 4443 -j REJECT\n\n");
	print("# MSN Messenger\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 1863 -j REJECT\n\n");
}

if ($EMAIL_OUT == "true")
{
	print("# Block Email Access to external servers\n\n");
	print("# SMTP\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 25 -j REJECT\n\n");
	print("# POP3\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 110 -j REJECT\n\n");
	print("# IMAP4\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 143 -j REJECT\n\n");
}
?>

# No match, so ACCEPT
$IPT -A tcp_outbound -p TCP -s 0/0 -j ACCEPT

###############################################################################
#
# INPUT Chain
#

echo "Process INPUT chain ..."

# Allow all on localhost
$IPT -A INPUT -p ALL -i $LO_IFACE -j ACCEPT

# Drop bad packets
$IPT -A INPUT -p tcp -j bad_tcp_packets

<?
//Rules for the private network
if ($GATEWAY == "true")
{
	print("# Rules for the private network (accessing gateway system itself)\n");
	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -s \$LOCAL_NET -j ACCEPT\n");
	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -d \$LOCAL_BCAST -j ACCEPT\n\n");

	print("# Allow broadcasts from ipv4 autoconfig.  Windows XP uses this.\n");
	print("# Others may as well.  Either of the following may be required.\n");
	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -d 169.254.255.255 -j ACCEPT\n");
	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -d 255.255.255.255 -j ACCEPT\n");
}
?>

# Inbound Internet Packet Rules

# Accept Established Connections
$IPT -A INPUT -p ALL -i $INET_IFACE -m state --state ESTABLISHED,RELATED -j ACCEPT

# Route the rest to the appropriate user chain
$IPT -A INPUT -p TCP -i $INET_IFACE -j tcp_inbound
$IPT -A INPUT -p UDP -i $INET_IFACE -j udp_inbound
$IPT -A INPUT -p ICMP -i $INET_IFACE -j icmp_packets

# Log packets that still don't match
$IPT -A INPUT -m limit --limit 3/minute --limit-burst 3 -j LOG \
     --log-prefix "INPUT packet died: "

###############################################################################
#
# FORWARD Chain
#

echo "Process FORWARD chain ..."

# Used if forwarding for a private network

# Drop bad packets
$IPT -A FORWARD -p tcp -j bad_tcp_packets

<?
// If private network exists
if ($GATEWAY == "true")
{
	print("# Accept TCP packets we want to forward from internal sources\n");
	print("\$IPT -A FORWARD -p tcp -i \$LOCAL_IFACE -j tcp_outbound\n\n");

	print("# Accept UDP packets we want to forward from internal sources\n");
	print("\$IPT -A FORWARD -p udp -i \$LOCAL_IFACE -j udp_outbound\n\n");

	print("# If not blocked, accept any other packets from the internal interface\n");
	print("\$IPT -A FORWARD -p ALL -i \$LOCAL_IFACE -j ACCEPT\n\n");

	print("# Deal with responses from the internet\n");
	print("\$IPT -A FORWARD -i \$INET_IFACE -m state --state ESTABLISHED,RELATED -j ACCEPT\n");
}
?>

# Log packets that still don't match
$IPT -A FORWARD -m limit --limit 3/minute --limit-burst 3 -j LOG \
     --log-prefix "FORWARD packet died: "

###############################################################################
#
# OUTPUT Chain
#

echo "Process OUTPUT chain ..."

# Generally trust the firewall on output

# Localhost
$IPT -A OUTPUT -p ALL -s $LO_IP -j ACCEPT

# To internal network
$IPT -A OUTPUT -p ALL -s $LOCAL_IP -j ACCEPT

# To internet
$IPT -A OUTPUT -p ALL -o $INET_IFACE -j ACCEPT

# Log packets that still don't match
$IPT -A OUTPUT -m limit --limit 3/minute --limit-burst 3 -j LOG \
     --log-prefix "OUTPUT packet died: "

###############################################################################
#
# nat table
#
###############################################################################

# The nat table is where network address translation occurs if there
# is a private network.  If the gateway is connected to the Internet
# with a static IP, snat is used.  If the gateway has a dynamic address,
# masquerade must be used instead.  There is more overhead associated
# with masquerade, so snat is better when it can be used.
# The nat table has a builtin chain, PREROUTING, for dnat and redirects.
# Another, POSTROUTING, handles snat and masquerade.

echo "Load rules for nat table ..."

###############################################################################
#
# PREROUTING chain
#

<?
// If TRANSPARENT_PROXY option set, redirect port 80 and port 443 to the
// REDIRECT_PORT on the gateway machine
if ($TRANSPARENT_PROXY == "true")
{
	print("# This is a sample that will exempt a specific host from the transparent proxy\n");
	print("#\$IPT -t nat -A PREROUTING -p tcp -s 192.168.1.50 --destination-port 80 -j RETURN\n");
	print("#\$IPT -t nat -A PREROUTING -p tcp -s 192.168.1.50 --destination-port 443 -j RETURN\n\n");

	print("# Redirect HTTP for a transparent proxy\n");
	print("\$IPT -t nat -A PREROUTING -p tcp --destination-port 80 -j REDIRECT --to-ports $REDIRECT_PORT\n");
	print("# Redirect HTTPS for a transparent proxy\n");
	print("\$IPT -t nat -A PREROUTING -p tcp --destination-port 443 -j REDIRECT --to-ports $REDIRECT_PORT\n");
}
?>

###############################################################################
#
# POSTROUTING chain
#

<?
if ($DYNAMIC_IP == "true")	//use masquerade target
{
	print("\$IPT -t nat -A POSTROUTING -o \$INET_IFACE -j MASQUERADE\n");
}
else						//static, so use snat target
{
	print("\$IPT -t nat -A POSTROUTING -o \$INET_IFACE -j SNAT --to-source \$INET_ADDRESS\n");
}
?>

###############################################################################
#
# mangle table
#
###############################################################################

# The mangle table is used to alter packets.  It can alter or mangle them in
# several ways.  For the purposes of this generator, we only use its ability
# to alter the TTL in packets.  However, it can be used to set netfilter
# mark values on specific packets.  Those marks could then be used in another
# table like filter, to limit activities associated with a specific host, for
# instance.  The TOS target can be used to set the Type of Service field in
# the IP header.  Note that the TTL target may not be included in the
# distribution on your system.  If it is not and you require it, you will
# have to add it.  That may require that you build from source.

echo "Load rules for mangle table ..."

<?
//Reset the TTL is requested to do so.
if ($MANGLE_TTL == "true")
{
	print("# Set the TTL in outbound packets to the same consistent value.\n");
	print("# A value around 128 is a good value.  Do not set this too high as\n");
	print("# it will adversely affect your network.  It is also considered bad\n");
	print("# form on the Internet.\n"); 
	print("\$IPT -t mangle -A PREROUTING -o \$INET_IFACE -j TTL --ttl-set $TTL\n");
}
?>

