<?
// Copyright 2002 Timothy Scott Morizot
//
// This file is part of Easy Firewall Generator for IPTables.
//
// Easy Firewall Generator for IPTables is free software;
// you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Easy Firewall Generator for IPTables is distributed
// in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// in this distribution; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Changelog:
//
// 5/20/2002 - tsm: Added logic to display Internal DHCP and External
//                  DHCP options

function DrawForm()
{
	global $INET_IFACE;
	global $DYNAMIC_IP;
	global $INET_ADDRESS;
	global $GATEWAY;
	global $LOCAL_IFACE;
	global $LOCAL_IP;
	global $LOCAL_NET;
	global $LOCAL_BCAST;
	global $SPECIAL_LAN;
	global $MANGLE_TTL;
	global $TTL;
	global $TRANSPARENT_PROXY;
	global $REDIRECT_PORT;
	global $BLOCK_OUTBOUND;
	global $INTERNAL_DHCP;
	global $HTTP_OUT;
	global $IRC_OUT;
	global $TELNET_OUT;
	global $FTP_OUT;
	global $IM_OUT;
	global $NEWS_OUT;
	global $EMAIL_OUT;
	global $SSH_OUT;
	global $INBOUND_ALLOW;
	global $HTTP_IN;
	global $DNS_IN;
	global $SSH_IN;
	global $EMAIL_IN;
	global $FTP_IN;
	global $NTP_IN;
	global $DHCP_IN;

	print("<?xml version=\"1.0\"?>\n");	
	print("<!DOCTYPE html PUBLIC\n");
	print("  \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n");
	print("  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");

	print("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
	print("<head>\n");
	print("<meta name=\"Author\" content=\"Scott Morizot\" />\n");
	print("<title>IPTABLES Firewall Generator</title>\n");
	print("</head>\n");

	print("<body>\n");

	print("<SCRIPT LANGUAGE=\"JavaScript\">\n");
	print("<!-- hide from JavaScript-challenged browsers\n");
	print("  function openHelp(helpFile,helpName) {\n");
	print("    popupWin = window.open(helpFile,helpName,'scrollbars,resizable,width=400,height=600');\n");
	print("  }\n");
	print("// done hiding -->\n");
	print("</SCRIPT>\n");

	print("<h1 align=\"center\">Easy Firewall Generator for IPTables</h1>\n");
	print("<h2 align=\"center\">Version 1.04</h2>\n");

	print("<p>This program generates an <strong>iptables</strong> firewall script\n");
	print("for use with the 2.4 linux kernel.  It is intended for use on a single\n");
	print("system connected to the Internet or a gateway system for a private, internal\n");
	print("network.  It provides a range of options, but is not intended to cover\n");
	print("every possible situation.  Make sure you understand what each option in the\n");
	print("generator does and take the time to read the comments in the resulting\n");
	print("firewall.  This generator will not, for example, generate a firewall\n");
	print("suitable for use with a DMZ, but it can provide a starting point.\n");
	print("For the most common uses the generator should produce a firewall\n");
	print("ready for use.</p>\n\n");
	
	print("<p><a href=\"iptables-info.html\" target=\"_blank\">Read here</a> for more information\n");
	print("on iptables firewalls.</p>\n\n");

	print("<p><a href=\"resources.html\" target=\"_blank\">Links</a> to additional firewall resources.</p>\n");

	print("<p>Select the desired options and click the <strong>Generate Firewall!</strong>\n");
	print("button.  If your choices require additional input, the Options will redisplay,\n");
	print("perhaps with more options displayed.  When the options are in a completed state\n");
	print("the firewall will be returned as a text document.  Save the result as iptables\n");
	print("for redhat systems or rc.firewall for many others.</p>\n\n");

	print("<form action=\"$PHP_SELF\" method=\"post\">\n");

	//Define Internet Interface
	print("<p>Internet Interface: ");
	print("<input type=\"text\" name=\"INET_IFACE\" value=\"$INET_IFACE\" size=\"6\" tabindex=\"1\" />\n"); 
	print("<a href=\"javascript:openHelp('help-interface.html','interfaces');\">Help</a></p>\n");

	//Static or Dynamic Internet Address?
	print("<p><strong>Select Type of Internet Address</strong>\n");
	print("<a href=\"javascript:openHelp('help-dynamic.html','dynamic');\">Help</a><br />\n");
	print("<input type=\"radio\" name=\"DYNAMIC_IP\" value=\"false\" tabindex=\"2\" ");
	if ($DYNAMIC_IP == "false")
	{
		print("checked=\"true\" ");
	}
	print("/> Static Internet IP Address ");
	if ($DYNAMIC_IP == "false")
	{
		print("<input type=\"text\" name=\"INET_ADDRESS\" value=\"$INET_ADDRESS\" size=\"15\" tabindex=\"3\" />");
		print("<a href=\"javascript:openHelp('help-ipaddress.html','ipaddress');\">Help</a>\n");
	}
	print("<br />\n"); 

	print("<input type=\"radio\" name=\"DYNAMIC_IP\" value=\"true\" tabindex=\"4\" ");
	if ($DYNAMIC_IP == "true")
	{
		print("checked=\"true\" ");
	}
	print("/> Dynamic Internet IP Address</p>\n");

	//Single sytem or gateway/firewall for LAN?
	print("<p><strong>Single System or Private Network Gateway?</strong>\n");
	print("<a href=\"javascript:openHelp('help-gateway.html','gateway');\">Help</a><br />\n");
	print("<input type=\"radio\" name=\"GATEWAY\" value=\"false\" tabindex=\"5\" ");
	if ($GATEWAY == "false")
	{
		print("checked=\"true\" ");
	}
	print("/> Single System <br />\n");
	print("<input type=\"radio\" name=\"GATEWAY\" value=\"true\" tabindex=\"6\" ");
	if ($GATEWAY == "true")
	{
		print("checked=\"true\" ");
	}
	print("/> Gateway/Firewall ");
	if ($GATEWAY == "true")
	{
		//Private network values
		print("<br />\n<ol type=\"a\">\n");
		print("<li>Internal Network Interface: <input type=\"text\" name=\"LOCAL_IFACE\" ");
		print("value=\"$LOCAL_IFACE\" size=\"6\" tabindex=\"7\" />\n");
		print("<a href=\"javascript:openHelp('help-interface.html','interfaces');\">Help</a></li>\n");
		print("<li>Internal Network IP Address: <input type=\"text\" name=\"LOCAL_IP\" ");
		print("value=\"$LOCAL_IP\" size=\"15\" tabindex=\"8\" />\n");
		print("<a href=\"javascript:openHelp('help-ipaddress.html','ipaddress');\">Help</a></li>\n");
		print("<li>Internal Network: <input type=\"text\" name=\"LOCAL_NET\" ");
		print("value=\"$LOCAL_NET\" size=\"20\" tabindex=\"9\" />\n");
		print("<a href=\"javascript:openHelp('help-network.html','network');\">Help</a></li>\n");
		print("<li>Internal Network Broadcast: <input type=\"text\" name=\"LOCAL_BCAST\" ");
		print("value=\"$LOCAL_BCAST\" size=\"15\" tabindex=\"10\" />\n");
		print("<a href=\"javascript:openHelp('help-broadcast.html','broadcast');\">Help</a></li></ol></p>\n");

		//Also add options that apply to internal network
		print("<p><input type=\"checkbox\" name=\"SPECIAL_LAN\" value=\"true\" tabindex=\"11\" ");
		if ($SPECIAL_LAN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> <strong>Advanced Network Options</strong> \n");
		print("<a href=\"javascript:openHelp('help-advanced.html','advanced');\">Help</a>\n");
		if ($SPECIAL_LAN == "true") //Provide advanced options
		{
			print("<br />\n<ul>\n");

			//Operate an internal dhcp server
			print("<li><input type=\"checkbox\" name=\"INTERNAL_DHCP\" value=\"true\" tabindex=\"12\" ");
			if ($INTERNAL_DHCP == "true")
			{
				print("checked=\"true\" ");
			}
			print("/> Internal DHCP Server ");
			print("\n<a href=\"javascript:openHelp('help-internaldhcp.html','internaldhcp');\">Help</a>\n");
			print("</li>\n");

			//Mangle the TTL option
			print("<li><input type=\"checkbox\" name=\"MANGLE_TTL\" value=\"true\" tabindex=\"13\" ");
			if ($MANGLE_TTL == "true")
			{
				print("checked=\"true\" ");
			}
			print("/> Mangle the Packet TTL ");
			if ($MANGLE_TTL == "true")
			{
				print("- <i>TTL:</i> ");
				print("<input type=\"text\" name=\"TTL\" ");
				print("value=\"$TTL\" size=\"4\" tabindex=\"14\" />");
			}
			print("\n<a href=\"javascript:openHelp('help-manglettl.html','manglettl');\">Help</a>\n");
			print("</li>\n");

			//Transparent Proxy
			print("<li><input type=\"checkbox\" name=\"TRANSPARENT_PROXY\" value=\"true\" tabindex=\"15\" ");
			if ($TRANSPARENT_PROXY == "true")
			{
				print("checked=\"true\" ");
			}
			print("/> Transparent Web Proxy ");
			if ($TRANSPARENT_PROXY == "true")
			{
				print("- <i>Redirect Port:</i> ");
				print("<input type=\"text\" name=\"REDIRECT_PORT\" ");
				print("value=\"$REDIRECT_PORT\" size=\"6\" tabindex=\"16\" />");
			}
			print("\n<a href=\"javascript:openHelp('help-redirect.html','redirect');\">Help</a>\n");
			print("</li>\n");

			//Block outbound services
			print("<li><input type=\"checkbox\" name=\"BLOCK_OUTBOUND\" value=\"true\" tabindex=\"17\" ");
			if ($BLOCK_OUTBOUND == "true")
			{
				print("checked=\"true\" ");
			}
			print("/> Block Outbound Services \n");
			print("<a href=\"javascript:openHelp('help-blockout.html','blockout');\">Help</a>\n");
			if ($BLOCK_OUTBOUND == "true")
			{
				//Individual services
				print("<br />\n<ul type=\"square\">\n");
				
				//IRC
				print("<li><input type=\"checkbox\" name=\"IRC_OUT\" value=\"true\" tabindex=\"18\" ");
				if ($IRC_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> IRC </li>");

				//Telnet
				print("<li><input type=\"checkbox\" name=\"TELNET_OUT\" value=\"true\" tabindex=\"19\" ");
				if ($TELNET_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> Telnet </li>");

				//HTTP
				print("<li><input type=\"checkbox\" name=\"HTTP_OUT\" value=\"true\" tabindex=\"20\" ");
				if ($HTTP_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> HTTP </li>");

				//FTP
				print("<li><input type=\"checkbox\" name=\"FTP_OUT\" value=\"true\" tabindex=\"21\" ");
				if ($FTP_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> FTP </li>");

				//Instant Messenger
				print("<li><input type=\"checkbox\" name=\"IM_OUT\" value=\"true\" tabindex=\"22\" ");
				if ($IM_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> Instant Messenger </li>");

				//NNTP
				print("<li><input type=\"checkbox\" name=\"NEWS_OUT\" value=\"true\" tabindex=\"23\" ");
				if ($NEWS_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> Usenet News </li>");

				//Email
				print("<li><input type=\"checkbox\" name=\"EMAIL_OUT\" value=\"true\" tabindex=\"24\" ");
				if ($EMAIL_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> Email </li>");

				//SSH
				print("<li><input type=\"checkbox\" name=\"SSH_OUT\" value=\"true\" tabindex=\"25\" ");
				if ($SSH_OUT == "true")
				{
					print("checked=\"true\" ");
				}
				print("/> SSH </li>");

				print("</ul>\n");
			}
			print("</li>\n</ul>\n");
		}
		print("</p>\n");
	}
	print("</p>\n"); 
	
	//Allow inbound services
	print("<p><input type=\"checkbox\" name=\"INBOUND_ALLOW\" value=\"true\" tabindex=\"26\" ");
	if ($INBOUND_ALLOW == "true")
	{
		print("checked=\"true\" ");
	}
	print("/> <strong>Allow Inbound Services</strong> \n");
	print("<a href=\"javascript:openHelp('help-allowin.html','allowin');\">Help</a>\n");
	if ($INBOUND_ALLOW == "true")
	{
		//Individual services
		print("<br />\n<ul type=\"square\">\n");
		
		//SSH
		print("<li><input type=\"checkbox\" name=\"SSH_IN\" value=\"true\" tabindex=\"27\" ");
		if ($SSH_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> SSH </li>");

		//DNS
		print("<li><input type=\"checkbox\" name=\"DNS_IN\" value=\"true\" tabindex=\"28\" ");
		if ($DNS_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> DNS Server </li>");

		//HTTP
		print("<li><input type=\"checkbox\" name=\"HTTP_IN\" value=\"true\" tabindex=\"29\" ");
		if ($HTTP_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> Web Server </li>");

		//FTP
		print("<li><input type=\"checkbox\" name=\"FTP_IN\" value=\"true\" tabindex=\"30\" ");
		if ($FTP_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> FTP Server </li>");

		//Email
		print("<li><input type=\"checkbox\" name=\"EMAIL_IN\" value=\"true\" tabindex=\"31\" ");
		if ($EMAIL_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> Email Server </li>");

		//NTP
		print("<li><input type=\"checkbox\" name=\"NTP_IN\" value=\"true\" tabindex=\"32\" ");
		if ($NTP_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> Time Server (NTP) </li>");

		//External DHCP Server
		print("<li><input type=\"checkbox\" name=\"DHCP_IN\" value=\"true\" tabindex=\"33\" ");
		if ($DHCP_IN == "true")
		{
			print("checked=\"true\" ");
		}
		print("/> DHCP Server (on the Internet interface) </li>");

		print("</ul>\n");
	}
	print("</p>\n");

	//Submit button
	print("<p><input type=\"submit\" value=\"Generate Firewall!\" tabindex=\"50\" /></p>\n");	

	//Close form
	print("</form>\n");

	//Close document
	print("</body>\n</html>\n");
}

?>

