<?php
// Copyright 2002 Timothy Scott Morizot
//
// This file is part of Easy Firewall Generator for IPTables.
//
// Easy Firewall Generator for IPTables is free software;
// you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Easy Firewall Generator for IPTables is distributed
// in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// in this distribution; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Changelog:
//
// 05/20/2002 - tsm: Updated to check for internal dhcp and external
//                   dhcp options.

/*includes*/

/*
 *Check and see if this is the first time the page has been called
 *use the internet interface option to determine this
 *Other than the first time it is called, it is always set.
 *If it is set, then this is a response to a form submission
 *In that case, assume everything is completed
 *If not, reset completed when it's determined it's not completed.
*/
if ($INET_IFACE == "")
{
	$INET_IFACE="eth0";
	$COMPLETED="false";
}
else
{
	$COMPLETED="true";
}

/*Check if static or dynamic*/
if ($DYNAMIC_IP == "")
{
	$DYNAMIC_IP="true";
	$COMPLETED="false";
}
else if ($DYNAMIC_IP == "false")
{
	if ($INET_ADDRESS == "")
	{
		$COMPLETED="false";
	}
}

//Validate single system or gateway
if ($GATEWAY == "")
{
	$GATEWAY="false";
	$COMPLETED="false";
}
else if ($GATEWAY == "true")
{
	//Validate internal interface
	if ($LOCAL_IFACE == "")
	{
		$LOCAL_IFACE="eth1";
		$COMPLETED="false";
	}
	//Validate internal IP
	if ($LOCAL_IP == "")
	{
		$LOCAL_IP="192.168.1.1";
		$COMPLETED="false";
	}
	//Validate internal network
	if ($LOCAL_NET == "")
	{
		$LOCAL_NET="192.168.1.0/24";
		$COMPLETED="false";
	}
	//Validate internal broadcast
	if ($LOCAL_BCAST == "")
	{
		$LOCAL_BCAST="192.168.1.255";
		$COMPLETED="false";
	}
	//Check if special section is activated
	//Then validate internal pieces
	if ($SPECIAL_LAN == "true")
	{
		//If no sub-values active, not completed
		if ($MANGLE_TTL == "" && $TRANSPARENT_PROXY == "" &&
			$BLOCK_OUTBOUND == "" && $INTERNAL_DHCP == "")
		{
			$COMPLETED="false";
		}

		//If mangle selected, check TTL
		if ($MANGLE_TTL == "true" && $TTL == "")
		{
			$TTL="128";
			$COMPLETED="false";
		}

		//If transparent proxy selected, need redirect port
		if ($TRANSPARENT_PROXY == "true" && $REDIRECT_PORT == "")
		{
			$COMPLETED="false";
		}

		//if block outbound selected, check to see if something
		//is selected.  If not, then it's not completed
		if ($BLOCK_OUTBOUND == "true" && $IRC_OUT == "" && $TELNET_OUT == "" &&
			$HTTP_OUT == "" && $FTP_OUT == "" && $IM_OUT == "" && $NEWS_OUT == "" &&
			$SSH_OUT == "" && $EMAIL_OUT == "")
		{
			$COMPLETED="false";
		}
	}
}

//If inbound allowed checked and none of the sub-values checked
//then it's not completed yet
if ($INBOUND_ALLOW == "true" && $HTTP_IN == "" && $DNS_IN == "" &&
	$SSH_IN == "" && $FTP_IN == "" && $EMAIL_IN == "" &&
	$NTP_IN == "" && $DHCP_IN == "")
{
	$SSH_IN = "true";
	$COMPLETED = "false";
}

//if completed return firewall, else redraw form
if ($COMPLETED == "false")
{
	include ('form.inc');
	DrawForm();
}
else
{
	include ('firewall.inc');
}

?>


