<?php
// Copyright 2002 Timothy Scott Morizot
//
// This file is part of my Easy Firewall Generator for IPTables.
//
// Easy Firewall Generator for IPTables is free software;
// you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Easy Firewall Generator for IPTables is distributed
// in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// in this distribution; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//Set type to plain text
header("Content-Type: text/plain");

?>
#!/bin/sh
#
# Generated iptables firewall script for the Linux 2.4 kernel
# Script generated by Easy Firewall Generator for IPTables 1.15
# copyright 2002 Timothy Scott Morizot
# 
# Redhat chkconfig comments - firewall applied early,
#                             removed late
# chkconfig: 2345 08 92
# description: This script applies or removes iptables firewall rules
# 
# This generator is primarily designed for RedHat installations,
# although it should be adaptable for others.
#
# It can be executed with the typical start and stop arguments.
# If used with stop, it will stop after flushing the firewall.
# The save and restore arguments will save or restore the rules
# from the /etc/sysconfig/iptables file.  The save and restore
# arguments are included to preserve compatibility with
# Redhat's init.d script (at least in 7.x) if you prefer to use it.

# Redhat installation instructions
#
# 1. Ensure that ipchains will not automatically start.
#    chkconfig --level 0123456 ipchains off
#    This will make sure that the ipchains init.d script
#    is not linked to an S file in any of the rc directories.
#
# 2. Stop ipchains if it's running.
#    service ipchains stop
#
# 3. Execute lsmod to see if the ipchains kernel module is still loaded.
#    If it is, use rmmod to unload it. -- rmmod ipchains
#
# 4. Have the system link the iptables init.d startup script into run states
#    2, 3, and 5.
#    chkconfig --level 235 iptables on
#
# 5. Save this script and execute it to load the ruleset from this file.
#    You may need to run the dos2unix command on it to remove carraige returns.
#
# 6. To have it applied at startup, copy this script to
#    /etc/init.d/iptables.  It accepts stop, start, save, and restore
#    arguments.  (You may wish to save the existing one first.)
#
# 7. For non-Redhat systems (or Redhat systems if you have a problem), you
#    may want to append the command to execute this script to rc.local.
#    rc.local is typically located in /etc and /etc/rc.d and is usually
#    the last thing executed on startup.  Simply add /path/to/script/script_name
#    on its own line in the rc.local file.

###############################################################################
# 
# Local Settings
#

# sysctl location.  If set, it will use sysctl to adjust the kernel parameters.
# If this is set to the empty string (or is unset), the use of sysctl
# is disabled.

SYSCTL="/sbin/sysctl -w" 

# To echo the value directly to the /proc file instead
# SYSCTL=""

# IPTables Location - adjust if needed

IPT="/sbin/iptables"
IPTS="/sbin/iptables-save"
IPTR="/sbin/iptables-restore"

# Internet Interface
<?php
print("INET_IFACE=\"" . $_POST['INET_IFACE'] . "\"\n");

if ($_POST['DYNAMIC_IP'] != "true")
{
	print("INET_ADDRESS=\"" . $_POST['INET_ADDRESS'] . "\"\n");
}	

if ($_POST['GATEWAY'] == "true")
{
	print("\n# Local Interface Information\n");
	print("LOCAL_IFACE=\"" . $_POST['LOCAL_IFACE'] . "\"\n");
	print("LOCAL_IP=\"" . $_POST['LOCAL_IP'] . "\"\n");
	print("LOCAL_NET=\"" . $_POST['LOCAL_NET'] . "\"\n");
	print("LOCAL_BCAST=\"" . $_POST['LOCAL_BCAST'] . "\"\n");
}

?>

# Localhost Interface

LO_IFACE="lo"
LO_IP="127.0.0.1"

# Save and Restore arguments handled here
if [ "$1" = "save" ]
then
	echo -n "Saving firewall to /etc/sysconfig/iptables ... "
	$IPTS > /etc/sysconfig/iptables
	echo "done"
	exit 0
elif [ "$1" = "restore" ]
then
	echo -n "Restoring firewall from /etc/sysconfig/iptables ... "
	$IPTR < /etc/sysconfig/iptables
	echo "done"
	exit 0
fi

###############################################################################
#
# Load Modules
#

echo "Loading kernel modules ..."

# You should uncomment the line below and run it the first time just to
# ensure all kernel module dependencies are OK.  There is no need to run
# every time, however.

# /sbin/depmod -a

# Unless you have kernel module auto-loading disabled, you should not
# need to manually load each of these modules.  Other than ip_tables,
# ip_conntrack, and some of the optional modules, I've left these
# commented by default.  Uncomment if you have any problems or if
# you have disabled module autoload.  Note that some modules must
# be loaded by another kernel module.

# core netfilter module
/sbin/modprobe ip_tables

# the stateful connection tracking module
/sbin/modprobe ip_conntrack

# filter table module
# /sbin/modprobe iptable_filter

# mangle table module
# /sbin/modprobe iptable_mangle

# nat table module
# /sbin/modprobe iptable_nat

# LOG target module
# /sbin/modprobe ipt_LOG

# This is used to limit the number of packets per sec/min/hr
# /sbin/modprobe ipt_limit

# masquerade target module
# /sbin/modprobe ipt_MASQUERADE

# filter using owner as part of the match
# /sbin/modprobe ipt_owner

# REJECT target drops the packet and returns an ICMP response.
# The response is configurable.  By default, connection refused.
# /sbin/modprobe ipt_REJECT

# This target allows packets to be marked in the mangle table
# /sbin/modprobe ipt_mark

# This target affects the TCP MSS
# /sbin/modprobe ipt_tcpmss

# This match allows multiple ports instead of a single port or range
# /sbin/modprobe multiport

# This match checks against the TCP flags
# /sbin/modprobe ipt_state

# This match catches packets with invalid flags
# /sbin/modprobe ipt_unclean

<?php

print("# The ftp nat module is required for non-PASV ftp support\n");
if ($_POST['FTP_OUT'] == "true")
{
	print("#");
}
print("/sbin/modprobe ip_nat_ftp\n\n");

print("# the module for full ftp connection tracking\n");
if ($_POST['FTP_OUT'] == "true")
{
	print("#");
}
print("/sbin/modprobe ip_conntrack_ftp\n\n");

print("# the module for full irc connection tracking\n");
if ($_POST['IRC_OUT'] == "true")
{
	print("#");
}
print("/sbin/modprobe ip_conntrack_irc\n\n");

?>

###############################################################################
#
# Kernel Parameter Configuration
#
# See http://ipsysctl-tutorial.frozentux.net/chunkyhtml/index.html
# for a detailed tutorial on sysctl and the various settings
# available.

<?php
print("# Required to enable IPv4 forwarding.\n");
print("# Redhat users can try setting FORWARD_IPV4 in /etc/sysconfig/network to true\n");
print("# Alternatively, it can be set in /etc/sysctl.conf\n");
if ($_POST['GATEWAY'] == "false")
{
	print("#if [ \"\$SYSCTL\" = \"\" ]\n");
	print("#then\n");
	print("#    echo \"1\" > /proc/sys/net/ipv4/ip_forward\n");
	print("#else\n");
	print("#    \$SYSCTL net.ipv4.ip_forward=\"1\"\n");
	print("#fi\n\n");
}
else
{
	print("if [ \"\$SYSCTL\" = \"\" ]\n");
	print("then\n");
	print("    echo \"1\" > /proc/sys/net/ipv4/ip_forward\n");
	print("else\n");
	print("    \$SYSCTL net.ipv4.ip_forward=\"1\"\n");
	print("fi\n\n");
}

print("# This enables dynamic address hacking.\n");
print("# This may help if you have a dynamic IP address \(e.g. slip, ppp, dhcp\).\n");
print("#if [ \"\$SYSCTL\" = \"\" ]\n");
print("#then\n");
print("#    echo \"1\" > /proc/sys/net/ipv4/ip_dynaddr\n");
print("#else\n");
print("#    \$SYSCTL net.ipv4.ip_dynaddr=\"1\"\n");
print("#fi\n\n");

print("# This enables SYN flood protection.\n");
print("# The SYN cookies activation allows your system to accept an unlimited\n");
print("# number of TCP connections while still trying to give reasonable\n");
print("# service during a denial of service attack.\n");
print("if [ \"\$SYSCTL\" = \"\" ]\n");
print("then\n");
print("    echo \"1\" > /proc/sys/net/ipv4/tcp_syncookies\n");
print("else\n");
print("    \$SYSCTL net.ipv4.tcp_syncookies=\"1\"\n");
print("fi\n\n");

print("# This enables source validation by reversed path according to RFC1812.\n");
print("# In other words, did the response packet originate from the same interface\n");
print("# through which the source packet was sent?  It's recommended for single-homed\n");
print("# systems and routers on stub networks.  Since those are the configurations\n");
print("# this firewall is designed to support, I turn it on by default.\n");
print("# Turn it off if you use multiple NICs connected to the same network.\n");
print("if [ \"\$SYSCTL\" = \"\" ]\n");
print("then\n");
print("    echo \"1\" > /proc/sys/net/ipv4/conf/all/rp_filter\n");
print("else\n");
print("    \$SYSCTL net.ipv4.conf.all.rp_filter=\"1\"\n");
print("fi\n\n");

print("# This option allows a subnet to be firewalled with a single IP address.\n");
print("# It's used to build a DMZ.  Since that's not a focus of this firewall\n");
print("# script, it's not enabled by default, but is included for reference.\n");
print("# See: http://www.sjdjweis.com/linux/proxyarp/ \n");
print("#if [ \"\$SYSCTL\" = \"\" ]\n");
print("#then\n");
print("#    echo \"1\" > /proc/sys/net/ipv4/conf/all/proxy_arp\n");
print("#else\n");
print("#    \$SYSCTL net.ipv4.conf.all.proxy_arp=\"1\"\n");
print("#fi\n\n");

print("# The following kernel settings were suggested by Alex Weeks. Thanks!\n\n");

print("# This kernel parameter instructs the kernel to ignore all ICMP\n");
print("# echo requests sent to the broadcast address.  This prevents\n");
print("# a number of smurfs and similar DoS nasty attacks.\n");
print("if [ \"\$SYSCTL\" = \"\" ]\n");
print("then\n");
print("    echo \"1\" > /proc/sys/net/ipv4/icmp_echo_ignore_broadcasts\n");
print("else\n");
print("    \$SYSCTL net.ipv4.icmp_echo_ignore_broadcasts=\"1\"\n");
print("fi\n\n");

print("# This option can be used to accept or refuse source routed\n");
print("# packets.  It is usually on by default, but is generally\n");
print("# considered a security risk.  This option turns it off.\n");
print("if [ \"\$SYSCTL\" = \"\" ]\n");
print("then\n");
print("    echo \"0\" > /proc/sys/net/ipv4/conf/all/accept_source_route\n");
print("else\n");
print("    \$SYSCTL net.ipv4.conf.all.accept_source_route=\"0\"\n");
print("fi\n\n");

print("# This option can disable ICMP redirects.  ICMP redirects\n");
print("# are generally considered a security risk and shouldn't be\n");
print("# needed by most systems using this generator.\n");
print("#if [ \"\$SYSCTL\" = \"\" ]\n");
print("#then\n");
print("#    echo \"0\" > /proc/sys/net/ipv4/conf/all/accept_redirects\n");
print("#else\n");
print("#    \$SYSCTL net.ipv4.conf.all.accept_redirects=\"0\"\n");
print("#fi\n\n");
print("# However, we'll ensure the secure_redirects option is on instead.\n");
print("# This option accepts only from gateways in the default gateways list.\n");
print("if [ \"\$SYSCTL\" = \"\" ]\n");
print("then\n");
print("    echo \"1\" > /proc/sys/net/ipv4/conf/all/secure_redirects\n");
print("else\n");
print("    \$SYSCTL net.ipv4.conf.all.secure_redirects=\"1\"\n");
print("fi\n\n");

print("# This option logs packets from impossible addresses.\n");
print("if [ \"\$SYSCTL\" = \"\" ]\n");
print("then\n");
print("    echo \"1\" > /proc/sys/net/ipv4/conf/all/log_martians\n");
print("else\n");
print("    \$SYSCTL net.ipv4.conf.all.log_martians=\"1\"\n");
print("fi\n\n");

?>

###############################################################################
#
# Flush Any Existing Rules or Chains
#

echo "Flushing Tables ..."

# Reset Default Policies
$IPT -P INPUT ACCEPT
$IPT -P FORWARD ACCEPT
$IPT -P OUTPUT ACCEPT
$IPT -t nat -P PREROUTING ACCEPT
$IPT -t nat -P POSTROUTING ACCEPT
$IPT -t nat -P OUTPUT ACCEPT
$IPT -t mangle -P PREROUTING ACCEPT
$IPT -t mangle -P OUTPUT ACCEPT

# Flush all rules
$IPT -F
$IPT -t nat -F
$IPT -t mangle -F

# Erase all non-default chains
$IPT -X
$IPT -t nat -X
$IPT -t mangle -X

if [ "$1" = "stop" ]
then
	echo "Firewall completely flushed!  Now running with no firewall."
	exit 0
fi

###############################################################################
#
# Rules Configuration
#

###############################################################################
#
# Filter Table
#
###############################################################################

# Set Policies

$IPT -P INPUT DROP
$IPT -P OUTPUT DROP
$IPT -P FORWARD DROP

###############################################################################
#
# User-Specified Chains
#
# Create user chains to reduce the number of rules each packet
# must traverse.

echo "Create and populate custom rule chains ..."

# Create a chain to filter INVALID packets

$IPT -N bad_packets

# Create another chain to filter bad tcp packets

$IPT -N bad_tcp_packets

# Create separate chains for icmp, tcp (incoming and outgoing),
# and incoming udp packets.

$IPT -N icmp_packets

# Used for UDP packets inbound from the Internet
$IPT -N udp_inbound

# Used to block outbound UDP services from internal network
# Default to allow all
$IPT -N udp_outbound

# Used to allow inbound services if desired
# Default fail except for established sessions
$IPT -N tcp_inbound

# Used to block outbound services from internal network
# Default to allow all
$IPT -N tcp_outbound

###############################################################################
#
# Populate User Chains
#

# bad_packets chain
#
# Drop INVALID packets immediately

<?php
// Check LOG_FIREPARSE to determine log-prefix format 
print("\$IPT -A bad_packets -p ALL -m state --state INVALID -j LOG \\\n");

if ($_POST['LOG_FIREPARSE'] == 'true')
{
	print("    --log-prefix \"fp=bad_packets:1 a=DROP \"\n");
}
else
{
	print("    --log-prefix \"Invalid packet: \"\n");
}
?>

$IPT -A bad_packets -p ALL -m state --state INVALID -j DROP

# Then check the tcp packets for additional problems
$IPT -A bad_packets -p tcp -j bad_tcp_packets

# All good, so return
$IPT -A bad_packets -p ALL -j RETURN

# bad_tcp_packets chain
#
# All tcp packets will traverse this chain.
# Every new connection attempt should begin with
# a syn packet.  If it doesn't, it is likely a
# port scan.  This drops packets in state
# NEW that are not flagged as syn packets.

<?php
//If there is a gateway, exempt the internal interface.
if ($_POST['GATEWAY'] == "true")
{
	print("# Return to the calling chain if the bad packets originate\n");
	print("# from the local interface. This maintains the approach\n");
	print("# throughout this firewall of a largely trusted internal\n");
	print("# network.\n");
	print("\$IPT -A bad_tcp_packets -p tcp -i \$LOCAL_IFACE -j RETURN\n\n");

	print("# However, I originally did apply this filter to the forward chain\n");
	print("# for packets originating from the internal network.  While I have\n");
	print("# not conclusively determined its effect, it appears to have the\n");
	print("# interesting side effect of blocking some of the ad systems.\n");
	print("# Apparently some ad systems have the browser initiate a NEW\n");
	print("# connection that is not flagged as a syn packet to retrieve\n");
	print("# the ad image.  If you wish to experiment further comment the\n");
	print("# rule above. If you try it, you may also wish to uncomment the\n");
	print("# rule below.  It will keep those packets from being logged.\n");
	print("# There are a lot of them.\n");
	print("# \$IPT -A bad_tcp_packets -p tcp -i \$LOCAL_IFACE ! --syn -m state \\\n");
	print("#     --state NEW -j DROP\n");
}
?>

<?php
// Check LOG_FIREPARSE to determine log-prefix format 
print("\$IPT -A bad_tcp_packets -p tcp ! --syn -m state --state NEW -j LOG \\\n");

if ($_POST['LOG_FIREPARSE'] == 'true')
{
	print("    --log-prefix \"fp=bad_tcp_packets:1 a=DROP \"\n");
}
else
{
	print("    --log-prefix \"New not syn: \"\n");
}
?>
$IPT -A bad_tcp_packets -p tcp ! --syn -m state --state NEW -j DROP

# All good, so return
$IPT -A bad_tcp_packets -p tcp -j RETURN

# icmp_packets chain
#
# This chain is for inbound (from the Internet) icmp packets only.
# Type 8 (Echo Request) is not accepted by default
# Enable it if you want remote hosts to be able to reach you.
# 11 (Time Exceeded) is the only one accepted
# that would not already be covered by the established
# connection rule.  Applied to INPUT on the external interface.
# 
# See: http://www.ee.siue.edu/~rwalden/networking/icmp.html
# for more info on ICMP types.
#
# Note that the stateful settings allow replies to ICMP packets.
# These rules allow new packets of the specified types.

# ICMP packets should fit in a Layer 2 frame, thus they should
# never be fragmented.  Fragmented ICMP packets are a typical sign
# of a denial of service attack.
<?php
// Check LOG_FIREPARSE to determine log-prefix format 
print("\$IPT -A icmp_packets --fragment -p ICMP -j LOG \\\n");

if ($_POST['LOG_FIREPARSE'] == 'true')
{
	print("    --log-prefix \"fp=icmp_packets:1 a=DROP \"\n");
}
else
{
	print("    --log-prefix \"ICMP Fragment: \"\n");
}
?>
$IPT -A icmp_packets --fragment -p ICMP -j DROP

# Echo - uncomment to allow your system to be pinged.
# Uncomment the LOG command if you also want to log PING attempts
# 
<?php
// Check LOG_FIREPARSE to determine log-prefix format 
print("# \$IPT -A icmp_packets -p ICMP -s 0/0 --icmp-type 8 -j LOG \\\n");

if ($_POST['LOG_FIREPARSE'] == 'true')
{
	print("#    --log-prefix \"fp=icmp_packets:2 a=ACCEPT \"\n");
}
else
{
	print("#    --log-prefix \"Ping detected: \"\n");
}
?>
# $IPT -A icmp_packets -p ICMP -s 0/0 --icmp-type 8 -j ACCEPT

# By default, however, drop pings without logging. Blaster
# and other worms have infected systems blasting pings.
# Comment the line below if you want pings logged, but it
# will likely fill your logs.
$IPT -A icmp_packets -p ICMP -s 0/0 --icmp-type 8 -j DROP

# Time Exceeded
$IPT -A icmp_packets -p ICMP -s 0/0 --icmp-type 11 -j ACCEPT

# Not matched, so return so it will be logged
$IPT -A icmp_packets -p ICMP -j RETURN

# TCP & UDP
# Identify ports at:
#    http://www.chebucto.ns.ca/~rakerman/port-table.html
#    http://www.iana.org/assignments/port-numbers

# udp_inbound chain
#
# This chain describes the inbound UDP packets it will accept.
# It's applied to INPUT on the external or Internet interface.
# Note that the stateful settings allow replies.
# These rules are for new requests.
# It drops netbios packets (windows) immediately without logging.

# Drop netbios calls
# Please note that these rules do not really change the way the firewall
# treats netbios connections.  Connections from the localhost and
# internal interface (if one exists) are accepted by default.
# Responses from the Internet to requests initiated by or through
# the firewall are also accepted by default.  To get here, the
# packets would have to be part of a new request received by the
# Internet interface.  You would have to manually add rules to
# accept these.  I added these rules because some network connections,
# such as those via cable modems, tend to be filled with noise from
# unprotected Windows machines.  These rules drop those packets
# quickly and without logging them.  This prevents them from traversing
# the whole chain and keeps the log from getting cluttered with
# chatter from Windows systems.
$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 137 -j DROP
$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 138 -j DROP

<?php
//Reject ident requests.  IRC User
if ($_POST['IRC_USER'] == "true")
{
	print("# Ident requests (Port 113) must have a REJECT rule rather than the\n");
	print("# default DROP rule.  This is the minimum requirement to avoid\n");
	print("# long delays while connecting.  Also see the tcp_inbound rule.\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 113 -j REJECT\n\n");

	print("# A more sophisticated configuration could accept the ident requests.\n");
	print("# \$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 113 -j ACCEPT\n\n");
	if ($_POST['GATEWAY'] == "true")
	{
		print("# However, if this is a gateway system that masquerades/nats for internal systems\n");
		print("# and the internal systems wish to chat, a simple changing these rules to\n");
		print("# ACCEPT won't work.  The ident daemon on the gateway will need to know how\n");
		print("# to handle the requests.  The stock daemon in most linux distributions\n");
		print("# can't do that.   oidentd is one package that can.\n");
		print("# See: http://dev.ojnk.net/\n\n");
	}
}

//NTP server on gateway
if ($_POST['NTP_IN'] == "true")
{
	print("# Network Time Protocol (NTP) Server\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 123 -j ACCEPT\n\n");
}

//DNS Server on gateway
if ($_POST['DNS_IN'] == "true")
{
	print("# DNS Server\n");
	print("# Configure the server to use port 53 as the source port for requests\n");
	print("# Note, if you run a caching-only name server that only accepts queries\n");
	print("# from the private network or localhost, you can comment out this line.\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 53 -j ACCEPT\n\n");
	print("# If you don't query-source the server to port 53 and you have problems,\n");
	print("# uncomment this rule.  It specifically allows responses to queries\n");
	print("# initiated to another server from a high UDP port.  The stateful\n");
	print("# connection rules should handle this situation, though.\n");
	print("# \$IPT -A udp_inbound -p UDP -s 0/0 --source-port 53 -j ACCEPT\n\n");
}

// If running a DHCP server on the Internet interface, allow the requests
if ($_POST['DHCP_IN'] == "true")
{
	print("# External DHCP Server\n");
	print("# Allow DHCP client request packets inbound from external network\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --source-port 68 --destination-port 67 \\\n");
	print("     -j ACCEPT\n\n");
}

//If it's a dynamic address, set rule to allow inbound DHCP
if ($_POST['DYNAMIC_IP'] == "true")
{
	print("# Dynamic Address\n");
	print("# If DHCP, the initial request is a broadcast. The response\n");
	print("# doesn't exactly match the outbound packet.  This explicitly\n");
	print("# allow the DHCP ports to alleviate this problem.\n");
	print("# If you receive your dynamic address by a different means, you\n");
	print("# can probably comment this line.\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --source-port 67 --destination-port 68 \\\n");
	print("     -j ACCEPT\n\n");
}

//Inbound NFS selected
if ($_POST['NFS_IN'] == "true")
{
	print("# Network File System (NFS) Server\n");
	print("# Please note that additional services must\n");
	print("# be configured in order to support an NFS Server through\n");
	print("# the firewall. Read the help in the generator or this site:\n");
	print("# http://www.lowth.com/LinWiz/nfs_help.html\n\n");

	print("# NFS Server - portmapper\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 111 -j ACCEPT\n\n");

	print("# NFS Server - statd\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port ");
	print($_POST['STATD_PORT']);
	print(" -j ACCEPT\n\n");

	print("# NFS Server - NFS daemon\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port 2049 -j ACCEPT\n\n");

	print("# NFS Server - lockd\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port ");
	print($_POST['LOCKD_PORT']);
	print(" -j ACCEPT\n\n");

	print("# NFS Server - mountd\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port ");
	print($_POST['MOUNTD_PORT']);
	print(" -j ACCEPT\n\n");

	print("# NFS Server - quotad\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port ");
	print($_POST['RQUOTAD_PORT']);
	print(" -j ACCEPT\n\n");
}

//User specified inbound rule
if ($_POST['OTHER_IN'] == "true" && $_POST['OTHER_IN_UDP'] == "true")
{
	print("# User specified allowed UDP protocol\n");
	print("\$IPT -A udp_inbound -p UDP -s 0/0 --destination-port ");
	print($_POST['OTHER_IN_FROM']);
	if ($_POST['OTHER_IN_TO'] != "")
	{
		print(":" . $_POST['OTHER_IN_TO']);
	}
	print(" -j ACCEPT\n\n");
}

?>

# Not matched, so return for logging
$IPT -A udp_inbound -p UDP -j RETURN

# udp_outbound chain
#
# This chain is used with a private network to prevent forwarding for
# UDP requests on specific protocols.  Applied to the FORWARD rule from
# the internal network.  Ends with an ACCEPT

<?php

//If IM blocked, block ICQ, which uses UDP 4000
if ($_POST['IM_OUT'] == "true")
{
	print("# ICQ uses UDP 4000 - Instant messaging blocked\n");
	print("\$IPT -A udp_outbound -p UDP -s 0/0 --destination-port 4000 -j REJECT\n\n");
}

?>

# No match, so ACCEPT
$IPT -A udp_outbound -p UDP -s 0/0 -j ACCEPT

# tcp_inbound chain
#
# This chain is used to allow inbound connections to the
# system/gateway.  Use with care.  It defaults to none.
# It's applied on INPUT from the external or Internet interface.

<?php

//Reject ident requests.  IRC User
if ($_POST['IRC_USER'] == "true")
{
	print("# Ident requests (Port 113) must have a REJECT rule rather than the\n");
	print("# default DROP rule.  This is the minimum requirement to avoid\n");
	print("# long delays while connecting.  Also see the tcp_inbound rule.\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 113 -j REJECT\n\n");

	print("# A more sophisticated configuration could accept the ident requests.\n");
	print("# \$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 113 -j ACCEPT\n\n");
	if ($_POST['GATEWAY'] == "true")
	{
		print("# However, if this is a gateway system that masquerades/nats for internal systems\n");
		print("# and the internal systems wish to chat, a simple changing these rules to\n");
		print("# ACCEPT won't work.  The ident daemon on the gateway will need to know how\n");
		print("# to handle the requests.  The stock daemon in most linux distributions\n");
		print("# can't do that.   oidentd is one package that can.\n");
		print("# See: http://dev.ojnk.net/\n\n");
	}
}

//DNS Server - TCP (most are UDP, so this could be disabled)
if ($_POST['DNS_IN'] == "true")
{
	print("# DNS Server - Allow TCP connections (zone transfers and large requests)\n");
	print("# This is disabled by default.  DNS Zone transfers occur via TCP.\n");
	print("# If you need to allow transfers over the net you need to uncomment this line.\n");
	print("# If you allow queries from the 'net, you also need to be aware that although\n");
	print("# DNS queries use UDP by default, a truncated UDP query can legally be\n");
	print("# submitted via TCP instead.  You probably will never need it, but should\n");
	print("# be aware of the fact.\n");
	print("# \$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 53 -j ACCEPT\n\n");
}

//HTTP
if ($_POST['HTTP_IN'] == "true")
{
	print("# Web Server\n\n");
	print("# HTTP\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 80 -j ACCEPT\n\n");
	
	if ($_POST['HTTPSSL_IN'] == "true")
	{
		print("# HTTPS (Secure Web Server)\n");
		print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 443 -j ACCEPT\n\n");
	}
}

//FTP
if ($_POST['FTP_IN'] == "true")
{
	print("# FTP Server (Control)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 21 -j ACCEPT\n\n");
	print("# FTP Client (Data Port for non-PASV transfers)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --source-port 20 -j ACCEPT\n\n");

	//Passive FTP
	print("# Passive FTP\n");
	print("# \n");
	print("# With passive FTP, the server provides a port to the client\n");
	print("# and allows the client to initiate the connection rather\n");
	print("# than initiating the connection with the client from the data port.\n");
	print("# Web browsers and clients operating behind a firewall generally\n");
	print("# use passive ftp transfers.  A general purpose FTP server\n");
	print("# will need to support them.\n");
	print("# \n");
	print("# However, by default an FTP server will select a port from the entire\n");
	print("# range of high ports.  It is not particularly safe to open all\n");
	print("# high ports.  Fortunately, that range can be restricted.  This\n");
	print("# firewall presumes that the range has been restricted to a specific\n");
	print("# selected range.  That range must also be configured in the ftp server.\n");
	print("# \n");
	print("# Instructions for specifying the port range for the wu-ftpd server\n");
	print("# can be found here:\n");
	print("# http://www.wu-ftpd.org/man/ftpaccess.html\n");
	print("# (See the passive ports option.)\n");
	print("# \n");
	print("# Instructions for the ProFTPD server can be found here:\n");
	print("# http://proftpd.linux.co.uk/localsite/Userguide/linked/x861.html\n\n");
	if ($_POST['PASSIVE_IN'] == "true")
	{
		print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
		print($_POST['PASSIVE_PORT_FROM'] . ":" . $_POST['PASSIVE_PORT_TO'] . " -j ACCEPT\n\n");
	}
	else
	{
		print("# Sample Rule\n");
		print("# \$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 62000:64000");
		print(" -j ACCEPT\n\n");
	}
}

//Email
if ($_POST['EMAIL_IN'] == "true")
{
	print("# Email Server (SMTP)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 25 -j ACCEPT\n\n");
	print("# Email Server (POP3)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 110 -j ACCEPT\n\n");
	print("# Email Server (IMAP4)\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 143 -j ACCEPT\n\n");
	
	if ($_POST['EMAILSSL_IN'] == "true")
	{
		print("# SSL Email Server (POP3)\n");
		print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 995 -j ACCEPT\n\n");
		print("# SSL Email Server (IMAP4)\n");
		print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 993 -j ACCEPT\n\n");
	}
}

//SSH
if ($_POST['SSH_IN'] == "true")
{
	print("# sshd\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 22 -j ACCEPT\n\n");
}

if ($_POST['IM_IN'] == "true")
{
	print("# ICQ File Transfers & Other Advanced Features\n");
	print("# \n");
	print("# ICQ supports a number of options beyond simple instant messaging.\n");
	print("# For those to function, the instant messaging system must allow\n");
	print("# new connections initiated from remote systems. This option will\n");
	print("# open a specified port range on the firewalled system.  The ICQ client\n");
	print("# on the firewalled system must also be configured to use the specified\n");
	print("# port range.\n\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['IM_PORT_FROM'] . ":" . $_POST['IM_PORT_TO'] . " -j ACCEPT\n\n");
}

if ($_POST['MESSENGER_IN'] == "true")
{
	print("# MSN Messenger File Transfers\n");
	print("# \n");
	print("# Messenger supports file transfers.  For transfers initiated by\n");
	print("# remote systems to function, the system must allow\n");
	print("# new connections initiated from remote systems a specific port range.\n");
	print("# This option defaults to the port range 6891 through 6900.\n");
	print("# Unless the MSN Messenger client can be configured to specify any\n");
	print("# port range, don't change the default.\n\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['MSN_PORT_FROM'] . ":" . $_POST['MSN_PORT_TO'] . " -j ACCEPT\n\n");
}

//Inbound NFS selected
if ($_POST['NFS_IN'] == "true")
{
	print("# Network File System (NFS) Server\n");
	print("# Please note that additional services must\n");
	print("# be configured in order to support an NFS Server through\n");
	print("# the firewall. Read the help in the generator or this site:\n");
	print("# http://www.lowth.com/LinWiz/nfs_help.html\n\n");

	print("# NFS Server - portmapper\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 111 -j ACCEPT\n\n");

	print("# NFS Server - statd\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['STATD_PORT']);
	print(" -j ACCEPT\n\n");

	print("# NFS Server - NFS daemon\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port 2049 -j ACCEPT\n\n");

	print("# NFS Server - lockd\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['LOCKD_PORT']);
	print(" -j ACCEPT\n\n");

	print("# NFS Server - mountd\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['MOUNTD_PORT']);
	print(" -j ACCEPT\n\n");

	print("# NFS Server - quotad\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['RQUOTAD_PORT']);
	print(" -j ACCEPT\n\n");
}

//User specified inbound rule
if ($_POST['OTHER_IN'] == "true" && $_POST['OTHER_IN_TCP'] == "true")
{
	print("# User specified allowed UDP protocol\n");
	print("\$IPT -A tcp_inbound -p TCP -s 0/0 --destination-port ");
	print($_POST['OTHER_IN_FROM']);
	if ($_POST['OTHER_IN_TO'] != "")
	{
		print(":" . $_POST['OTHER_IN_TO']);
	}
	print(" -j ACCEPT\n\n");
}

?>

# Not matched, so return so it will be logged
$IPT -A tcp_inbound -p TCP -j RETURN

# tcp_outbound chain
#
# This chain is used with a private network to prevent forwarding for
# requests on specific protocols.  Applied to the FORWARD rule from
# the internal network.  Ends with an ACCEPT

<?php
if ($_POST['IRC_OUT'] == "true")
{
	print("# Block IRC\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 194 -j REJECT\n\n");
}

if ($_POST['TELNET_OUT'] == "true")
{
	print("# Block Outbound Telnet\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 23 -j REJECT\n\n");
}

if ($_POST['SSH_OUT'] == "true")
{
	print("# Block SSH\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 22 -j REJECT\n\n");
}

if ($_POST['NEWS_OUT'] == "true")
{
	print("# Block Usenet Access\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 119 -j REJECT\n\n");
}

if ($_POST['HTTP_OUT'] == "true")
{
	print("# Block Web Access\n\n");
	print("# HTTP\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 80 -j REJECT\n\n");
	print("# HTTPS (Secure Web)\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 443 -j REJECT\n\n");
}

if ($_POST['FTP_OUT'] == "true")
{
	print("# Block FTP Access\n\n");
	print("# Control\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 21 -j REJECT\n\n");
	print("# Data\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 20 -j REJECT\n\n");
}

if ($_POST['IM_OUT'] == "true")
{
	print("# Block Instant Messaging\n\n");
	print("# AIM\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 5190 -j REJECT\n\n");
	print("# AIM Images\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 4443 -j REJECT\n\n");
	print("# MSN Messenger\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 1863 -j REJECT\n\n");
}

if ($_POST['EMAIL_OUT'] == "true")
{
	print("# Block Email Access to external servers\n\n");
	print("# SMTP\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 25 -j REJECT\n\n");
	print("# POP3\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 110 -j REJECT\n\n");
	print("# IMAP4\n");
	print("\$IPT -A tcp_outbound -p TCP -s 0/0 --destination-port 143 -j REJECT\n\n");
}
?>

# No match, so ACCEPT
$IPT -A tcp_outbound -p TCP -s 0/0 -j ACCEPT

###############################################################################
#
# INPUT Chain
#

echo "Process INPUT chain ..."

# Allow all on localhost interface
$IPT -A INPUT -p ALL -i $LO_IFACE -j ACCEPT

# Drop bad packets
$IPT -A INPUT -p ALL -j bad_packets

# DOCSIS compliant cable modems
# Some DOCSIS compliant cable modems send IGMP multicasts to find
# connected PCs.  The multicast packets have the destination address
# 224.0.0.1.  You can accept them.  If you choose to do so,
# Uncomment the rule to ACCEPT them and comment the rule to DROP
# them  The firewall will drop them here by default to avoid
# cluttering the log.  The firewall will drop all multicasts
# to the entire subnet (224.0.0.1) by default.  To only affect
# IGMP multicasts, change '-p ALL' to '-p 2'.  Of course,
# if they aren't accepted elsewhere, it will only ensure that
# multicasts on other protocols are logged.
# Drop them without logging.
$IPT -A INPUT -p ALL -d 224.0.0.1 -j DROP
# The rule to accept the packets.
# $IPT -A INPUT -p ALL -d 224.0.0.1 -j ACCEPT

<?php
//Rules for the private network
if ($_POST['GATEWAY'] == "true")
{
	print("# Rules for the private network (accessing gateway system itself)\n");
	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -s \$LOCAL_NET -j ACCEPT\n");
	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -d \$LOCAL_BCAST -j ACCEPT\n\n");

// The following rule is the generic fix for these.
//	print("# Allow broadcasts from ipv4 autoconfig.  Windows XP uses this.\n");
//	print("# Others may as well.  Either of the following may be required.\n");
//	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -d 169.254.255.255 -j ACCEPT\n");
//	print("\$IPT -A INPUT -p ALL -i \$LOCAL_IFACE -d 255.255.255.255 -j ACCEPT\n");

	//If running DHCP internally from this server, also allow dhcp client requests
	if ($_POST['INTERNAL_DHCP'] == "true")
	{
		print("# Allow DHCP client request packets inbound from internal network\n");
		print("\$IPT -A INPUT -p UDP -i \$LOCAL_IFACE --source-port 68 --destination-port 67 \\\n");
		print("     -j ACCEPT\n\n");
	}

}
?>

# Inbound Internet Packet Rules

# Accept Established Connections
$IPT -A INPUT -p ALL -i $INET_IFACE -m state --state ESTABLISHED,RELATED \
     -j ACCEPT

# Route the rest to the appropriate user chain
$IPT -A INPUT -p TCP -i $INET_IFACE -j tcp_inbound
$IPT -A INPUT -p UDP -i $INET_IFACE -j udp_inbound
$IPT -A INPUT -p ICMP -i $INET_IFACE -j icmp_packets

# Drop without logging broadcasts that get this far.
# Cuts down on log clutter.
# Comment this line if testing new rules that impact
# broadcast protocols.
$IPT -A INPUT -p ALL -d 255.255.255.255 -j DROP

# Log packets that still don't match
<?php
// Check LOG_FIREPARSE to determine log-prefix format 
if ($_POST['LOG_FIREPARSE'] == 'true')
{
	print("\$IPT -A INPUT -j LOG --log-prefix \"fp=INPUT:99 a=DROP \"\n");
}
else
{
	print("\$IPT -A INPUT -m limit --limit 3/minute --limit-burst 3 -j LOG \\\n");
	print("    --log-prefix \"INPUT packet died: \"\n");
}
?>

###############################################################################
#
# FORWARD Chain
#

echo "Process FORWARD chain ..."

# Used if forwarding for a private network

<?php
// If private network exists
if ($_POST['GATEWAY'] == "true")
{
	print("# Drop bad packets\n");
	print("\$IPT -A FORWARD -p ALL -j bad_packets\n\n");

	print("# Accept TCP packets we want to forward from internal sources\n");
	print("\$IPT -A FORWARD -p tcp -i \$LOCAL_IFACE -j tcp_outbound\n\n");

	print("# Accept UDP packets we want to forward from internal sources\n");
	print("\$IPT -A FORWARD -p udp -i \$LOCAL_IFACE -j udp_outbound\n\n");

	print("# If not blocked, accept any other packets from the internal interface\n");
	print("\$IPT -A FORWARD -p ALL -i \$LOCAL_IFACE -j ACCEPT\n\n");

	print("# Deal with responses from the internet\n");
	print("\$IPT -A FORWARD -i \$INET_IFACE -m state --state ESTABLISHED,RELATED \\\n");
	print("     -j ACCEPT\n\n");

	// If port forwarding option selected, the forward chain must also
    // accept the port forwarding.
	if ($_POST['PORT_FORWARD'] == "true")
	{
		print("# Port Forwarding is enabled, so accept forwarded traffic\n");
		if ($_POST['PORT_FORWARD_UDP'] == "true")
		{
			print("\$IPT -A FORWARD -p udp ");
			print("-i \$INET_IFACE --destination-port ");
			if ($_POST['PORT_FORWARD_IPORT'] != "")
			{
				print($_POST['PORT_FORWARD_IPORT']);
			}
			else
			{
				print($_POST['PORT_FORWARD_FROM']);
				if ($_POST['PORT_FORWARD_TO'] != "")
				{
					print(":" . $_POST['PORT_FORWARD_TO']);
				}
			}
			print(" \\\n");
			print("     --destination " . $_POST['PORT_FORWARD_IP'] . " -j ACCEPT \n\n");
		}

		if ($_POST['PORT_FORWARD_TCP'] == "true")
		{
			print("\$IPT -A FORWARD -p tcp ");
			print("-i \$INET_IFACE --destination-port ");
			if ($_POST['PORT_FORWARD_IPORT'] != "")
			{
				print($_POST['PORT_FORWARD_IPORT']);
			}
			else
			{
				print($_POST['PORT_FORWARD_FROM']);
				if ($_POST['PORT_FORWARD_TO'] != "")
				{
					print(":" . $_POST['PORT_FORWARD_TO']);
				}
			}
			print(" \\\n");
			print("     --destination " . $_POST['PORT_FORWARD_IP'] . " -j ACCEPT \n\n");
		}
}

	print("# Log packets that still don't match\n");

	// Check LOG_FIREPARSE to determine log-prefix format 
	if ($_POST['LOG_FIREPARSE'] == 'true')
	{
		print("\$IPT -A FORWARD -j LOG --log-prefix \"fp=FORWARD:99 a=DROP \"\n");
	}
	else
	{
		print("\$IPT -A FORWARD -m limit --limit 3/minute --limit-burst 3 -j LOG \\\n");
		print("    --log-prefix \"FORWARD packet died: \"\n");
	}
}
?>

###############################################################################
#
# OUTPUT Chain
#

echo "Process OUTPUT chain ..."

# Generally trust the firewall on output

# However, invalid icmp packets need to be dropped
# to prevent a possible exploit.
$IPT -A OUTPUT -m state -p icmp --state INVALID -j DROP

# Localhost
$IPT -A OUTPUT -p ALL -s $LO_IP -j ACCEPT
$IPT -A OUTPUT -p ALL -o $LO_IFACE -j ACCEPT

<?php
// If private network exists
if ($_POST['GATEWAY'] == "true")
{
	print("# To internal network\n");
	print("\$IPT -A OUTPUT -p ALL -s \$LOCAL_IP -j ACCEPT\n");
	print("\$IPT -A OUTPUT -p ALL -o \$LOCAL_IFACE -j ACCEPT\n\n");
}
?>
# To internet
$IPT -A OUTPUT -p ALL -o $INET_IFACE -j ACCEPT

# Log packets that still don't match
<?php
// Check LOG_FIREPARSE to determine log-prefix format 
if ($_POST['LOG_FIREPARSE'] == 'true')
{
	print("\$IPT -A OUTPUT -j LOG --log-prefix \"fp=OUTPUT:99 a=DROP \"\n");
}
else
{
	print("\$IPT -A OUTPUT -m limit --limit 3/minute --limit-burst 3 -j LOG \\\n");
	print("    --log-prefix \"OUTPUT packet died: \"\n");
}
?>

###############################################################################
#
# nat table
#
###############################################################################

# The nat table is where network address translation occurs if there
# is a private network.  If the gateway is connected to the Internet
# with a static IP, snat is used.  If the gateway has a dynamic address,
# masquerade must be used instead.  There is more overhead associated
# with masquerade, so snat is better when it can be used.
# The nat table has a builtin chain, PREROUTING, for dnat and redirects.
# Another, POSTROUTING, handles snat and masquerade.

echo "Load rules for nat table ..."

###############################################################################
#
# PREROUTING chain
#

<?php
// If port forwarding option selected, build the rule here
if ($_POST['PORT_FORWARD'] == "true")
{
	print("# Port Forwarding\n");
	print("# \n");
	print("# Port forwarding forwards all traffic on a port or ports from\n");
	print("# the firewall to a computer on the internal LAN.  This can\n");
	print("# be required to support special situations.  For instance,\n");
	print("# this is the only way to support file transfers with an ICQ\n");
	print("# client on an internal computer.  It's also required if an internal\n");
	print("# system hosts a service such as a web server.  However, it's also\n");
	print("# a dangerous option.  It allows Internet computers access to\n");
	print("# your internal network.  Use it carefully and only if you're\n");
	print("# certain you know what you're doing.\n\n");

	if ($_POST['PORT_FORWARD_UDP'] == "true")
	{
		print("\$IPT -t nat -A PREROUTING -p udp ");
		print("-i \$INET_IFACE --destination-port " . $_POST['PORT_FORWARD_FROM']);
		if ($_POST['PORT_FORWARD_TO'] != "")
		{
			print(":" . $_POST['PORT_FORWARD_TO']);
		}
		print(" \\\n");
		print("     -j DNAT --to-destination " . $_POST['PORT_FORWARD_IP']);
		if ($_POST['PORT_FORWARD_IPORT'] != "")
		{
			print(":" . $_POST['PORT_FORWARD_IPORT']);
		}
		print("\n\n");
	}

	if ($_POST['PORT_FORWARD_TCP'] == "true")
	{
		print("\$IPT -t nat -A PREROUTING -p tcp ");
		print("-i \$INET_IFACE --destination-port " . $_POST['PORT_FORWARD_FROM']);
		if ($_POST['PORT_FORWARD_TO'] != "")
		{
			print(":" . $_POST['PORT_FORWARD_TO']);
		}
		print(" \\\n");
		print("     -j DNAT --to-destination " . $_POST['PORT_FORWARD_IP']);
		if ($_POST['PORT_FORWARD_IPORT'] != "")
		{
			print(":" . $_POST['PORT_FORWARD_IPORT']);
		}
		print("\n\n");
	}

	if ($_POST['PORT_FORWARD_REDIRECT_INTERNAL'] == "true")
	{
		if ($_POST['PORT_FORWARD_UDP'] == "true")
		{
			print("\$IPT -t nat -A PREROUTING -p udp ");
			print("-i \$LOCAL_IFACE --destination-port " . $_POST['PORT_FORWARD_FROM']);
			if ($_POST['PORT_FORWARD_TO'] != "")
			{
				print(":" . $_POST['PORT_FORWARD_TO']);
			}
			print(" \\\n");
			print("     --destination \$INET_ADDRESS -j DNAT --to-destination " . $_POST['PORT_FORWARD_IP']);
			if ($_POST['PORT_FORWARD_IPORT'] != "")
			{
				print(":" . $_POST['PORT_FORWARD_IPORT']);
			}
			print("\n\n");
		}

		if ($_POST['PORT_FORWARD_TCP'] == "true")
		{
			print("\$IPT -t nat -A PREROUTING -p tcp ");
			print("-i \$LOCAL_IFACE --destination-port " . $_POST['PORT_FORWARD_FROM']);
			if ($_POST['PORT_FORWARD_TO'] != "")
			{
				print(":" . $_POST['PORT_FORWARD_TO']);
			}
			print(" \\\n");
			print("     --destination \$INET_ADDRESS -j DNAT --to-destination " . $_POST['PORT_FORWARD_IP']);
			if ($_POST['PORT_FORWARD_IPORT'] != "")
			{
				print(":" . $_POST['PORT_FORWARD_IPORT']);
			}
			print("\n\n");
		}
	}
}

// If TRANSPARENT_PROXY option set, redirect port 80 and port 443 to the
// REDIRECT_PORT on the gateway machine
if ($_POST['TRANSPARENT_PROXY'] == "true")
{
	print("# This is a sample that will exempt a specific host from the transparent proxy\n");
	print("#\$IPT -t nat -A PREROUTING -p tcp -s 192.168.1.50 --destination-port 80 \\\n");
	print("#     -j RETURN\n");
	print("#\$IPT -t nat -A PREROUTING -p tcp -s 192.168.1.50 --destination-port 443 \\\n");
	print("#     -j RETURN\n\n");

	print("# Redirect HTTP for a transparent proxy\n");
	print("\$IPT -t nat -A PREROUTING -p tcp --destination-port 80 \\\n");
	print("     -j REDIRECT --to-ports " . $_POST['REDIRECT_PORT'] . "\n");
	print("# Redirect HTTPS for a transparent proxy - commented by default\n");
	print("# \$IPT -t nat -A PREROUTING -p tcp --destination-port 443 \\\n");
	print("#     -j REDIRECT --to-ports " . $_POST['REDIRECT_PORT'] . "\n");
}
?>

###############################################################################
#
# POSTROUTING chain
#

<?php
//If it's a gateway then install either snat or masquerade.
if ($_POST['GATEWAY'] == "true")
{
	if ($_POST['DYNAMIC_IP'] == "true")	//use masquerade target
	{
		print("\$IPT -t nat -A POSTROUTING -o \$INET_IFACE -j MASQUERADE\n");
	}
	else						//static, so use snat target
	{
		print("\$IPT -t nat -A POSTROUTING -o \$INET_IFACE \\\n");
		print("     -j SNAT --to-source \$INET_ADDRESS\n");
		if ($_POST['PORT_FORWARD_REDIRECT_INTERNAL'] == "true")
		{
			print("\$IPT -t nat -A POSTROUTING -o \$LOCAL_IFACE \\\n");
			print("     -j SNAT --to-source \$INET_ADDRESS\n");
		}
	}
}
?>

###############################################################################
#
# mangle table
#
###############################################################################

# The mangle table is used to alter packets.  It can alter or mangle them in
# several ways.  For the purposes of this generator, we only use its ability
# to alter the TTL in packets.  However, it can be used to set netfilter
# mark values on specific packets.  Those marks could then be used in another
# table like filter, to limit activities associated with a specific host, for
# instance.  The TOS target can be used to set the Type of Service field in
# the IP header.  Note that the TTL target might not be included in the
# distribution on your system.  If it is not and you require it, you will
# have to add it.  That may require that you build from source.

echo "Load rules for mangle table ..."

<?php
//Reset the TTL is requested to do so.
if ($_POST['MANGLE_TTL'] == "true")
{
	print("# Set the TTL in outbound packets to the same consistent value.\n");
	print("# A value around 128 is a good value.  Do not set this too high as\n");
	print("# it will adversely affect your network.  It is also considered bad\n");
	print("# form on the Internet.\n"); 
	print("\$IPT -t mangle -A OUTPUT -o \$INET_IFACE -j TTL --ttl-set ");
	print($_POST['TTL'] . "\n");
}
?>
